// Routing control for REST API
'use strict';
/**
* @apiDefine AccessTokenHeader
* @apiHeader {String} FM-Data-token Users unique access-key.
*/

/**
* @apiDefine ContentTypeHeader
* @apiHeader {String} Content-Type=application/json Only accept "application/json".
*/

/**
* @apiDefine AcceptCharsetHeader
* @apiHeader {String} Accept-Charset  "utf-8",  or "utf-16" for JCK support.
* This header is only for none-browser client which refuses to set this header for security reason.
*/

/**
* @apiDefine SuccessResonseCode
* @apiSuccess {String} errorCode "0"
*/


/**
* @apiDefine ApiVersion
* @apiVersion 0.0.0
*/


var express = require('express');
var router = express.Router({caseSensitive: true});
var licenseApi = require('./api_license');
var cursorApi = require('./api_cursor');

router.use('/:version/databases/:solution/layouts/:layout/cursor', function (req, res, next) {
	res.locals.cursorToken = req.get('X-FM-Data-Cursor-Token');
	next();
});

router.use('/:version/databases/:solution/layouts/:layout/cursor', cursorApi.router);
router.use('/:version/refreshLicense', licenseApi.router);

router.use(function(req, res, next){
	next();
});


module.exports.router = router;
